 ; Ŀ
 ;   Fang - run Lisp routines on a directory of drawings.                  
 ;   Copyright 1995, 1997, 1999 by Rocket Software                         
 ;   Unless you like to do repetitious work                                
 ;                                     while your computer has coffee.     
 ;                                                                         
 ;   Don't forget to add the following line to Acad.pgp:                   
 ;   XXX,       cmd/c XXX,            0,XXX: ,                             
 ;   The cmd/c forces acad to wait for the the shell to finish before      
 ;   resuming, so that changes made to the file are finalized before       
 ;   Fang reads it.                                                        
 ;                                                                         
 ;   Notes: premade filename list files can contain comments either after  
 ;   the drawing name or on separate lines; each must be preceded by a     
 ;   semicolon and (if it is on the same line as a filename) separated     
 ;   from the filename by a space.                                         
 ;   Empty lines are ok, a leading space will cause any line to be         
 ;   ignored.                                                              
 ;                                                                         
 ;   Fang attempts to allow for the different Dir formats used by          
 ;   various operating systems, although as of R14 there aren't any.       
 ;   Fang should still work with previous revs.                            
 ; 

 ; Ŀ
 ;   Zak - make the raw directory dump file Files.zak.                     
 ;   Arguments: Dirr - the directory path.                                 
 ;              Dirt - the directory specification.                        
 ;              Isnt - the "OS is NT" flag.                                
 ;                                                                         
 ;   Returns nothing, but only when the file is ready.                     
 ; 
 (DEFUN ZAK (dirr dirt isnt / insp dirr num zk)
 ; Ŀ
 ;   If are running under NT, see if subdirectories should be processed.   
 ;   This is done before the first shell command so that there is only     
 ;   one flipscreen rather than two separated by an input.                 
 ; 
  (if isnt
      (progn
           (initget 0 "Yes No")
           (setq insp (getkword "Include Subdirectories? <N>: ")))
      (setq insp "No"))
 ; Ŀ
 ;   Make sure that Dirr, the directory name prefix, is in the format      
 ;   that Dos will accept.                                                 
 ; 
  (setq dirr (car (chug "\\" (chr 92) dirr)))
 ; Ŀ
 ;   First delete any old copies of the directory dump file Files.zak.     
 ; 
  (setq num 0)
  (while (setq zk (findfile "files.zak"))
         (if (= 12 (setq num (1+ num)))
             (progn
                  (alert (strcat "System Error:"
                                 "\nCan't erase " zk
                                 "\nPlease manually delete this file"
                                 "\nand restart Fang."))
                  (exit)))
         (command "shell" (strcat "del " zk))
         (command "delay" 250))
 ; Ŀ
 ;   Make the new Files.zak.                                               
 ; 
  (if (= insp "Yes")
      (command "shell" (strcat "dir /s /on \"" dirr dirt "\" > files.zak"))
      (command "shell" (strcat "dir /on \"" dirr dirt "\" > files.zak")))
 ; Ŀ
 ;   Now wait until the new file appears - this may take a few seconds     
 ;   depending on network traffic, operating system, etc.                  
 ; 
  (setq num 0)
  (while (not (findfile "files.zak"))
         (if (= 12 (setq num (1+ num)))
             (progn
                  (alert "System Error:\nCan't find Files.zak")
                  (exit)))
         (command "delay" 250))
 (princ))
 ; Ŀ
 ;   Zak end.                                                              
 ; 

 ; Ŀ
 ;   Deep: filename file Preprocessor & valid line counter.                
 ;   Takes the names and comments file name as an argument, returns the    
 ;   number of lines in the names only file Names.zak (which it writes.)   
 ;   (Note that that is Names.zak, not the dir dump file Files.zak.)       
 ; 
 (DEFUN DEEP (filnam / fn fog txtstr flist found)
  (setq numlin 0)
  (setq fn (open filnam "r"))
  (setq fog (open "names.zak" "w"))
  (while (setq txtstr (read-line fn))
         (while (= (substr txtstr 1 1) " ")
                (setq txtstr (substr txtstr 2)))
 ; Ŀ
 ;   NT problem: if there is a space in the path name then Split will      
 ;   ditch everything after it, rather than everything after the           
 ;   semicolon.                                                            
 ;   So do a Splat, chopping the string up at semicolons and then ditch    
 ;   the second string if there is more than one, and the whole line if    
 ;   it begins with a semicolon.                                           
 ; 
         (if (and (/= txtstr "")
                  (/= (substr txtstr 1 1) ";"))
             (progn
                  (setq flist (splat ";" txtstr))
                  (setq txtstr (car flist))
                  (if (/= txtstr "")
                      (progn
                           (write-line txtstr fog)
                           (setq numlin (1+ numlin)))))))
  (close fn)
  (close fog)
 ; Ŀ
 ;   Make sure Names.zak is written before ending the routine.             
 ; 
  (while (not (findfile "names.zak"))
         (if (= 12 (setq num (1+ num)))
             (progn
                  (alert "System Error:\nCan't find Names.zak"))
                  (exit))
             (command "delay" 250))
 numlin)
 ; Ŀ
 ;   Deep end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Splat - divide a text string into a list of substrings.    
 ;   Arguments: Sepchr, the field separator character.                     
 ;              Linn, the text string.                                     
 ;   Returns a list of field values, removes leading and trailing spaces.  
 ;                                                                         
 ;   This could probably replace Split wherever it is called...            
 ; 
 (DEFUN SPLAT (sepchr linn / len pos name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) sepchr)
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (while (= (substr name1 (setq len (strlen name1))) " ")
                (setq name1 (substr name1 1 (1- len))))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Splat end.                                                            
 ; 

 ; Ŀ
 ;   Patho - returns the first directory in the Acad search path.          
 ; 
 (DEFUN PATHO (/ goon acpth ppath)
  (setq goon t)
 ; Ŀ
 ;   If Patho is called under Win95 the function is not redefined (as it   
 ;   is under NT) by the main function Fang to return "", so if the        
 ;   environment variable Acad isn't found, put the file in C:.            
 ;   (Considered putting the file in the current directory, but didn't     
 ;   want to litter up the I: drive...)                                    
 ; 
  (if (setq acpth (getenv "acad"))
      (progn
           (setq acpth (splat ";" acpth))
           (while (and goon (setq ppath (car acpth)))
                  (setq acpth (cdr acpth))
                  (if (= (strcase (substr ppath 1 1)) "C")
                      (setq goon ()))))
      (setq ppath "C:\\"))
  (if (/= (substr ppath (strlen ppath)) "\\")
      (setq ppath (strcat ppath "\\")))
 ppath)
 ; Ŀ
 ;   Patho end.                                                            
 ; 

 ; Ŀ
 ;   Dive - process a line of windows NT directory listing.                
 ;   Arguments: Txt - the line of text.                                    
 ;              Prefa - the path string.                                   
 ;                                                                         
 ;   Returns a list: what the line contained: "dir", "file", or nil,       
 ;   and the file or directory name or "".                                 
 ;                                                                         
 ;   Will probably replace ForNT.                                          
 ; 
 (DEFUN DIVE (txt prefa / strlst typp num str)
  (setq txt (car (chug "\\" (chr 92) txt)))
  (setq strlst (split txt))
  (cond ((and (> (strlen txt) 5) (= (substr txt 1 6) " Direc"))
         (setq typp "Pref")
 ; Ŀ
 ;   Split will lose anything after a space if there is one in a           
 ;   directory path, so assume that the directory string will always be    
 ;   the same length and use everything after it.                          
 ; 
;         (setq txt (nth 2 strlst))
         (setq txt (substr txt 15))
 ; Ŀ
 ;   Make sure there is a backslash on the end of the directory string.    
 ; 
         (if (/= (substr txt (strlen txt)) "\\")
             (setq txt (strcat txt "\\"))))
        ((or (= txt "") (= (substr txt 1 1) " ")
             (member "<DIR>" strlst))
         (setq typp nil)
         (setq txt ""))
        (T
         (setq typp "file")
         (setq strlst (cdddr strlst))
         (setq txt "")
         (setq num 0)
         (while (setq str (nth num strlst))
                (if (/= txt "")
                    (setq txt (strcat txt " " str))
                    (setq txt str))
                (setq num (1+ num)))))
  (if (and (> (strlen txt) 3)
           (= (strcase (substr txt (- (strlen txt) 3))) ".DWG"))
      (setq txt (substr txt 1 (- (strlen txt) 4))))
 (list typp txt))
 ; Ŀ
 ;   Dive end.                                                             
 ; 

 ; Ŀ
 ;   ForNT - takes a text string in Windows NT dir format, returns the     
 ;   filename or "" if there wasn't one on that line.                      
 ; 
 (DEFUN FORNT (txt / strlst num str)
  (setq strlst (split txt))
  (if (or (= txt "")
          (= (substr txt 1 1) " ")
          (member "<DIR>" strlst))
      (setq txt "")
      (progn
           (setq strlst (cdddr strlst))
           (setq txt "")
           (setq num 0)
           (while (setq str (nth num strlst))
                  (if (/= txt "")
                      (setq txt (strcat txt " " str))
                      (setq txt str))
                  (setq num (1+ num)))))
  (if (and (/= txt "")
           (= (strcase (substr txt (- (strlen txt) 3))) ".DWG"))
      (setq txt (substr txt 1 (- (strlen txt) 4))))
 txt)
 ; Ŀ
 ;   ForNT end.                                                            
 ; 

 ; Ŀ
 ;   ForDos - takes a text string in Dos dir format, returns the filename  
 ;   or "" if there wasn't one on that line.                               
 ; 
 (DEFUN FORDOS (txt / len)
  (if (and (/= (substr txt 1 1) " ")
           (/= (substr txt 1 1) ".")
           (/= txt ""))
      (progn
           (setq txt (substr txt 1 10))
           (setq len 1)
           (while (/= (substr txt len 1) " ")
                  (setq len (1+ len)))
           (setq txt (substr txt 1 (1- len))))
      (setq txt ""))
 txt)
 ; Ŀ
 ;   ForDos end.                                                           
 ; 

 ; Ŀ
 ;   For95 - takes a text string in Win 95 dir format, returns the         
 ;   filename or "" if there wasn't one on that line.                      
 ; 
 (DEFUN FOR95 (txt / strlst len num str)
  (setq strlst (split txt))
  (if (or (member "<DIR>" strlst)
          (not (member "DWG" strlst)))
      (setq txt "")
      (progn
           (setq strlst (cdddr (cddr strlst)))
           (setq txt "")
           (setq num 0)
           (while (setq str (nth num strlst))
                  (if (/= txt "")
                      (setq txt (strcat txt " " str))
                      (setq txt str))
                  (setq num (1+ num)))))
  (if (and (/= txt "")
           (= (strcase (substr txt (- (strlen txt) 3))) ".DWG"))
      (setq txt (substr txt 1 (- (strlen txt) 4))))
 txt)
 ; Ŀ
 ;   For95 end.                                                            
 ; 

 ; Ŀ
 ;   Subroutine Split - divide a text string at spaces, make into a list   
 ;   of substrings.                                                        
 ; 
 (DEFUN SPLIT (linn / strlst pos len name1 strlst)
  (while (/= (strlen linn) 0)
         (while (and (= (substr linn 1 1) " ")
                     (/= (strlen linn) 0))
                (setq linn (substr linn 2)))
         (while (= (substr linn (setq len (strlen linn))) " ")
                (setq linn (substr linn 1 (1- len))))
         (setq pos 1)
         (setq len (strlen linn))
         (while (and (/= (substr linn pos 1) " ")
                     (>= len pos))
                (setq pos (1+ pos)))
         (setq name1 (substr linn 1 (1- pos)))
         (setq linn (substr linn (1+ pos)))
         (setq strlst (append strlst (list name1))))
  (if (null strlst) (setq strlst (list "")))
  strlst)
 ; Ŀ
 ;   Split end.                                                            
 ; 

 ; Ŀ
 ;   Nyx - various crap put here for the sake of organization.             
 ;   Get remaining inputs, call Stoker to write the script file.           
 ;   Takes the two arguments for Timer as arguments, only to pass them     
 ;   on to timer.                                                          
 ;   Calls Stoker, returns nothing.                                        
 ; 
 (DEFUN NYX (numlin start / num lispnm lsplst noron)
  (setq noron (list "fang" "tch" "tctitle"))  ; stuff not to run from fang
  (setq num 1)
 ; Ŀ
 ;   Get the list of lisps to run.                                         
 ; 
  (while (or (/= "" (setq lispnm (getstring (strcat "Enter lisp name "
                                                    (itoa num) ": "))))
             (null lsplst))
         (cond ((member lispnm noron)
                (setq lnam (strcat (strcase (substr lispnm 1 1))
                                   (strcase (substr lispnm 2) t)))
                (prompt (strcat "Can't run " lnam " from a script.\n")))
               ((findfile (strcat lispnm ".lsp"))
                (grtext num lispnm)
                (setq num (1+ num))
                (grtext num " ")
                (grtext (1+ num) " ")
                (setq lsplst (append lsplst (list lispnm))))
               ((and (= lispnm "") (null lsplst))
                (prompt "Fang can't run on empty.\n"))
               (t
                (prompt "No such file found.\n"))))
 ; Ŀ
 ;   Ask whether to Quit or End.                                           
 ; 
  (setq eoq (strcat (getstring "End or Quit after each drawing <End>: ")))
  (if (or (= eoq "") (= eoq "E") (= eoq "END"))
      (setq eoq T)
      (setq eoq ()))
 ; Ŀ
 ;   Initialise quit or end confirmation string for script file.           
 ; 
  (setq conf (strcat "         (if (/= (getvar \"dbmod\") 0)"
                     "\n             (command \"" (if eoq "N" "Y") "\")"
                     "\n             (princ))"))
 ; Ŀ
 ;   Write the script file.                                                
 ; 
  (write-line "Writing script...")
  (setq fbat (open (strcat (patho) "fiat_lux.scr") "w"))
  (stoker lsplst fbat conf numlin start eoq)
 ; Ŀ
 ;   Close the script file.                                                
 ; 
  (close fbat)
 ; Ŀ
 ;   Offer to run Fiat_lux, end.                                           
 ; 
  (write-line "You are getting very sleepy...")         ; informational prompt
  (initget 0 "Yes No")
  (Setq insp (getkword "Start the script, children of the night? <Y>: "))
  (if (or (null insp) (= insp "Yes"))
      (command "script" (strcat (patho) "Fiat_lux"))))  ; run the script
 ; Ŀ
 ;   Nyx end.                                                              
 ; 

 ; Ŀ
 ;   Bram - make a new filename file if an existing one isn't named.       
 ;   also includes the former Tez - directory handler for either           
 ;   Windows NT or Dos/Windows.                                            
 ;   Makes the files "Files.zak" - the directory file - and the list of    
 ;   file names without extensions but with path added, which defaults to  
 ;   "Files.dat". (The file name is stored in the Filnam variable.)        
 ;   Calls either ForDos or ForNT to extract the filename from each line   
 ;   of the directory file.                                                
 ;                                                                         
 ;   Takes two arguments: Isnt, which is set if the OS is NT.              
 ;                        Proc, the procedure to process a line from       
 ;                        the directory file.                              
 ;   Returns nothing.                                                      
 ;                                                                         
 ;   Windows - a fair idea gone wrong.                                     
 ; 
 (DEFUN BRAM (isnt proc / dirf dirr dirt filp fn fo prefa txt llist typp datt)
 ; Ŀ
 ;   Get the directory path.  Offer the directory in which the current     
 ;   drawing is located as the default.                                    
 ;   Locally change any \\ pairs in the string to \'s so that the dir      
 ;   command won't get upset.                                              
 ; 
  (setq dirf (getvar "dwgprefix"))
  (setq dirr (getstring (strcat "Directory name <" dirf ">: ")))
  (if (= dirr "") (setq dirr dirf))
 ; Ŀ
 ;   Make sure there is a backslash on the end of the directory string.    
 ; 
  (if (/= (substr dirr (strlen dirr)) "\\")
      (setq dirr (strcat dirr "\\")))
 ; Ŀ
 ;   Get the file specification.                                           
 ; 
  (setq dirt (getstring "Directory specification <*.Dwg>: "))
  (if (= dirt "") (setq dirt "*.dwg"))
 ; Ŀ
 ;   Ask what to call the drawing names only text file.                    
 ; 
  (if (null filnam) (setq filnam "Files.dat"))
  (setq filp (getstring (strcat "File list filename <" filnam ">: ")))
  (if (/= filp "") (setq filnam filp))
 ; Ŀ
 ;   Call Zak to create the raw directory dump file Files.zak.             
 ; 
  (zak dirr dirt isnt)
 ; Ŀ
 ;   Process the raw directory dump file Files.zak and create the          
 ;   aforementioned drawing names only text file.                          
 ;   Open the input and output files.                                      
 ; 
  (setq fn (open "files.zak" "r"))
  (setq fo (open filnam "w"))
 ; Ŀ
 ;   The main loop: write the path and filename file.                      
 ;   There will be two of these, one for NT (with subdirectory             
 ;   capability), one for Dos and 95.                                      
 ; 
  (if isnt
      (progn
           (setq prefa "")
           (while (setq txt (read-line fn))
                  (setq llist (dive txt prefa))
                  (setq typp (car llist))
                  (setq datt (cadr llist))
                  (cond ((= typp "Pref")
                         (setq prefa datt))
                        ((= typp "file")
 ; Ŀ
 ;   If the line was a file name, add the directory path and replace each  
 ;   backslash with two so that the lisp interpreter will feed the file    
 ;   name to the findfile function properly.                               
 ;   Then write the resulting string out to the directory list file.       
 ; 
                         (setq datt (strcat prefa datt))
                         (setq datt (car (chug (chr 92)
                                          (strcat (chr 92) (chr 92)) datt)))
                         (write-line datt fo)))))
      (while (setq txt (read-line fn))
             (setq txt (eval proc))
             (if (/= txt "")
                 (write-line (strcat dirr txt) fo))))
  (close fo)
  (close fn)
 (princ))
 ; Ŀ
 ;   Bram end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine Stoker - write the script file Fiat_lux.scr.               
 ;   Takes six arguments: The lisp list Lsplst,                            
 ;                        The script file handle Fbat,                     
 ;                        The end or quit string Conf,                     
 ;                        Two arguments to be written into the script      
 ;                        file for the Timer subroutine:                   
 ;                           the total number of drawings Numlin,          
 ;                           and the start time Start,                     
 ;                        and the (End or Quit each drawing) flag Eoq.     
 ;                                                                         
 ;   Calls nothing, returns nothing: note that while Fiat_lux.scr calls    
 ;   Timer and any other routines input by the user, Stoker doesn't        
 ;   actually call them itself.                                            
 ; 
 (DEFUN STOKER (lsplst fbat conf numlin start eoq / numm var lispnm endp)
  (setq fv (Open "names.zak" "r"))
  (setq numm 1)
  (while (setq var (read-line fv))
 ; Ŀ
 ;   Write the timer/lap counter code.                                     
 ; 
         (write-line (strcat
               "(if (not timer) (load " (chr 34) "fang" (chr 34) "))") fbat)
         (write-line (strcat "(timer " (rtos start 2 2) " " (itoa numlin)
                                               " " (itoa numm) ")") fbat)
 ; Ŀ
 ;   Increment the lap counter.                                            
 ; 
         (setq numm (1+ numm))
 ; Ŀ
 ;   See if the drawing is present and unlocked before opening it.         
 ; 
         (write-line (strcat
                 "(if (and (findfile " (chr 34) var ".dwg" (chr 34) ")") fbat)
         (write-line (strcat
          "         (not (findfile " (chr 34) var ".dwk" (chr 34) ")))") fbat)
         (write-line "    (progn " fbat)
 ; Ŀ
 ;   Set the flag variable lispo - if this is nil then a new drawing has   
 ;   been opened and the lisps can be run.                                 
 ; 
         (write-line "         (setq lispo t)" fbat)
 ; Ŀ
 ;   Now write the "open" lines to the script file.                        
 ; 
         (write-line (strcat
                       "         (command " (chr 34) "open" (chr 34)")") fbat)
         (write-line conf fbat)                       ; really discard etc.?
         (write-line (strcat
                       "         (command " (chr 34) var (chr 34) ")))") fbat)
 ; Ŀ
 ;   Set the position in the lisp list variable.                           
 ; 
         (setq num 0)
 ; Ŀ
 ;   Write the code to check for the "Not OK to run the lisps" flag.       
 ; 
         (write-line "(if (not lispo)" fbat)
         (write-line "    (progn" fbat)
 ; Ŀ
 ;   Write the name of each lisp in the lsplst to the file - load and      
 ;   then run it.                                                          
 ; 
         (while (setq lispnm (nth num lsplst))
                (setq num (1+ num))
                (if (= num (length lsplst))
                    (setq endp "))")
                    (setq endp ""))
                (write-line (strcat "         (load " (chr 34) lispnm
                                                      (chr 34) ")") fbat)
                (write-line (strcat "         (C:" lispnm ")" endp) fbat)))
 ; Ŀ
 ;   End of While filenames loop.  Add the commands to delete temporary    
 ;   files and (End or Quit).                                              
 ; 
  (write-line "shell del *.zak" fbat)                           ; delete files
  (write-line (strcat "shell del " (patho) "fiat_lux.scr") fbat); delete script
  (if eoq
     (write-line "END" fbat)
     (progn
          (write-line "Quit" fbat)
          (write-line "Y" fbat)))                    ; really discard etc.?
  (close fv)                                         ; close the filename file
 (princ))
 ; Ŀ
 ;   Stoker end.                                                           
 ; 

 ; Ŀ
 ;   Chug - string substitution engine.  Takes the search string, the      
 ;   replacement string, and the target string as arguments, and returns   
 ;   a list of the (possibly modified) target string and the number of     
 ;   changes made.                                                         
 ; 
 (DEFUN CHUG (oldstr newstr exstr / pos chnum changd newlen chunk)
  (setq pos 1)
  (setq chnum 0)
  (setq changd ())
  (setq newlen (strlen newstr))
  (setq oldlen (strlen oldstr))
  (while (= oldlen (strlen (setq chunk (substr exstr pos oldlen))))
         (if (= chunk oldstr)
             (progn
                  (setq exstr (strcat (substr exstr 1 (1- pos))
                                       newstr
                                      (substr exstr (+ pos oldlen))))
                  (setq changd t)
                  (setq chnum (1+ chnum))
                  (setq pos (+ pos newlen)))
             (setq pos (1+ pos))))
 (list exstr chnum))
 ; Ŀ
 ;   Chug end.                                                             
 ; 

 ; Ŀ
 ;   Mint - Convert seconds to hours, minutes and seconds.                 
 ; 
 (DEFUN MINT (sec / hours mins)
  (setq hours (itoa (fix (/ sec 3600))))
  (setq sec (rem sec 3600))
  (setq mins (itoa (fix (/ sec 60))))
  (setq sec (itoa (fix (rem sec 60))))
  (if (= (strlen hours) 1) (setq hours (strcat "0" hours)))
  (if (= (strlen mins) 1) (setq mins (strcat "0" mins)))
  (if (= (strlen sec) 1) (setq sec (strcat "0" sec)))
  (strcat hours ":" mins ":" sec))
 ; Ŀ
 ;   Mint end.                                                             
 ; 

 ; Ŀ
 ;   Timer - Script file timer.                                            
 ;   Copyright 1994   Rocket Software                                      
 ;   Software to help alleviate the tedium of mindless labour.             
 ; 
 (DEFUN TIMER (t1 totnum done / s t2 elapse timea timlft)
 ; Ŀ
 ;   T1 = start time, Totnum = total drawings, Done = drawings finished    
 ; 
  (setq s (getvar "date"))
  (setq t2 (* 86400.0 (- s (fix s))))
  (setq elapse (- t2 t1))
 ; Ŀ
 ;   Write the lap counter before Done is decremented.                     
 ; 
  (grtext 1 " ")
  (grtext 2 (strcat (itoa done) "/" (itoa totnum)))
  (grtext 3 " ")
  (setq done (1- done))   ; decrement - timer called before curr. dwg processed
  (if (> done 0)
      (progn
           (setq timea (/ elapse (float done)))
           (setq timlft (* timea (- totnum done)))
           (grtext 4 " ")
           (grtext 5 "Time")
           (grtext 6 "--------")
           (grtext 7 "Elapsed:")
           (grtext 8 (mint elapse))
           (grtext 9 "--------")
           (grtext 10 "Left:")
           (grtext 11 (mint timlft))
           (grtext 12 "--------")
           (grtext 13 " ")
           (grtext 14 " ")
           (grtext 15 " ")))
 (princ))
 ; Ŀ
 ;   Timer end.                                                            
 ; 

 ; Ŀ
 ;   Ranf - say appropriate if not nice things about Windows.              
 ; 
 (DEFUN RANF (/ s nnum mlst)
  (setq mlst (list
  "\nWindows NT: save early, save often."
  "\nNew for Acad R14: the Save and Hope command."
  "\nToday's NT reliability quotient: 17.2%."
  "\nToday's Operating System Reliability Quotient (OSRQ): 4.2%."
  "\nWindows: give a Pentium the speed of an XT."
  "\nNT: the flat lukewarm beer of operating systems."
  "\nNT: the Winnebago of software."
  "\nIcons and mice: now the illiterate can use computers."
  "\nWhy are the guys in the black hats always running the network?."
  "\nWindows is to Norton Commander as an ostrich is to a tyrannosaur."
  "\nWindows: for those who think clutter is beautiful and sloth desirable."
  "\nWindows: gunboat diplomacy for the CPU set."
  "\nWindows NT: the first software written by monkeys on typewriters."
  "\nWindows NT: welcome to the 19th century."
  "\nWindows: now anyone can use a computer.  Anyone at all..."
  "\nWindows NT: howlin' with brain pain."
  "\nWindows NT: ideal for steam computers."
  "\nCharles Babbage, where are you when we need you?"
  "\nWindows: the first screen-saver-only operating system."
  "\nIrritation: the Fifth Horseman.  Rides a horse called \"Windows\"."
  "\nWindows: it's a real fun riot."
  "\nWindows: now you can do six things at once (none of them well.)"
  "\nWindows: no keyboard required (unless you actually want to accomplish something.)"
  "\nWindows: aren't you glad Bill Gates didn't start an airline?"
  "\nDos only does one thing at a time.  So does the SR-71 Blackbird."
  "\nWindows: money can't buy happiness.  Stupidity can be had cheaply, though."
  "\nWindows NT: The horror...the horror..."
  "\nWindows NT: relive those first, awkward days of CAD."
  "\nWindows NT: the garlic based mouthwash of software."
  "\nWindows: the only computer virus that comes with manuals."
  "\nWindows: Just about everything you need.  Sort of."
  "\nWindows NT: just like Novell. (Except for reliability and speed.)"
  "\nNT: Nice Try."
  "\nWindows NT: the Mike Vernon of software."
  "\nWindows NT: who can fathom its infinite mystery?"
  "\nWindows NT: the Russian Roulette of file management."
  "\nWindows NT: Viva Las Vegas."
  "\nWindows NT: The software salesmen of the world thank you."
  "\nThe hourglass icon actually represents the great pyramid being eroded by the wind."
  "\nWindows: Forever is a long time: too long when you're trying to save a drawing."
  "\nWindows NT: still one of life's great mysteries."
  "\nWindows: from the makers of the worlds first concrete sports car."
  "\nWindows NT: any similarity to the Bermuda triangle is purely coincidence."
  "\nWindows NT: the names have been changed to protect the guilty."
  "\nWindows: black comedy comes to the desktop."
  "\n\"Shiny finishes are for consumers, and little pictures are for children.\" - Joanna Russ."
  "\nWindows NT: the software equivalent of a giant squid driving a Honda Civic."
  "\nWindows now includes a free Chicken-with-its-head-cut-off emulator."
  "\nWindows: the only software that includes a Lamprey driver."
  "\nWindows Nt: that not good."
  "\nWindows: for people who still have an orange shag rug in their bedroom."
  "\nWindows Nt: the Jesse James of file security."
  "\nWindows and Marxism: work takes second place after ideological purity."
  "\nWindows - it's not all that much like having rats eat your clothing."
  "\nWindows: it makes a better wall than a window."
  "\nWindows: favourite software of the cockroach hive-mind."
  "\nToday's horoscope: you will find Windows NT slow and irritating."
  "\nWindows: the Metric system of computing."
  "\nWindows: it's not contagious (but there is no known cure.)"
  "\nWindows NT: it could be worse. (But most people can't use an abacus.)"
  "\nThink of Windows as a trailer park, and Dos as a tornado."
  "\nMicrosoft: Walt Disney's Evil Twin."
  "\nWindows NT: proof that Bill Gates is really a rubber suit full of tree frogs."
  ))
  (setq len (length mlst))
  (while (or (null nnum) (>= nnum len))
         (setq s (* (getvar "cdate") 10000000.0))
         (setq nnum (fix (* 100 (- s ( fix s))))))
  (prompt (strcat (nth nnum mlst) "\n"))
 (princ))
 ; Ŀ
 ;   Ranf end.                                                             
 ; 

 ; Ŀ
 ;   Fang - The evil mastermind.                                           
 ; 
 (DEFUN C:FANG (/ s isnt proc numlin lispnm lsplst dirr dirt fp fn fo tt txt
                                                             len fbat fv var)
  (setvar "cmdecho" 0)
 ; Ŀ
 ;   Initialise start time variable for Timer.                             
 ; 
  (setq s (getvar "date"))
  (setq start (* 86400.0 (- s (fix s))))          ; start time for timer
 ; Ŀ
 ;   See which platform AutoCAD is running on.  The sysvar Platform        
 ;   contains a string: 386 DOS Extender                                   
 ;                      Microsoft Windows                                  
 ;                      Microsoft Windows NT Version 3.50 (x86)            
 ;   New one for Windows 95:                                               
 ;                      Microsoft Windows Version 4.0 (x86)                
 ;   Dos and Windows must be processed by the ForDos procedure, NT         
 ;   requires ForNT, if the Getvar call returns nil then this is an old    
 ;   version of Acad and probably running on a Dos system.  Anything else  
 ;   is problematical and will likely crash anyway, so test for NT and     
 ;   assume anything else to be Dos or equivalent.                         
 ;   Later note: 95 now has its own format which is handled by For95.      
 ;   ForNT probably needs to be cleaned up as well.                        
 ; 
  (setq plasti (split (getvar "platform")))
  (cond ((member "NT" plasti)
         (ranf)
         (setq isnt t)
         (setq proc '(fornt txt))
 ; Ŀ
 ;   The environment variable Acad isn't necessarily set in windows, so    
 ;   in this case redefine Patho to return "" and ignore the variable.     
 ; 
         (defun patho () ""))
        ((and (member "Windows" plasti) (member "Version" plasti)) ; not NT
         (ranf)
         (setq isnt t)
         (setq proc '(for95 txt))
         (defun patho () ""))
      (t (setq proc '(fordos txt))))
 ; Ŀ
 ;   Make the filename list file.                                          
 ; 
  (initget 0 "Yes No")
  (Setq usep (getkword "Make new file listing? <Y>: "))
  (if (or (null usep) (= usep "Yes"))
      (progn
           (setq numlin (bram isnt proc))
           (while (not (findfile filnam))
                  (if (= 12 (setq num (1+ num)))
                      (progn
                           (alert (strcat "System Error:\nCan't find "
                                           filnam "."))
                           (exit)))
                  (command "delay" 250))
           (initget 0 "Yes No")
           (Setq usep (getkword "Stop to edit drawing name file? <N>: "))
           (if (= usep "Yes")
               (command "not" filnam))
           (command "delay" 250)
           (setq numlin (deep filnam))
           (command "delay" 250)
           (nyx numlin start))
      (progn
           (if (null filnam) (setq filnam "Files.dat"))
           (setq filp (getstring (strcat "File list filename <" filnam ">: ")))
           (if (/= filp "") (setq filnam filp))
           (setq numlin (deep filnam))
           (nyx numlin start)))
 (princ))

